k6 v0.34.0 is here! :tada: It introduces the already announced `k6/execution` API and includes some more enhancements and a bunch of minor bug fixes.

## New k6 JavaScript API - `k6/execution`

The [k6/execution](https://k6.io/docs/javascript-api/k6-execution) module allows the fetching of information about the current VU, instance (mostly relevant in distributed/cloud) or scenario execution state through a series of exported properties.

### How to use

Some of the previously suggested solutions with the globally available `__VU` and `__ITER` values, such as for [getting a unique object per iteration from an array](https://community.k6.io/t/when-parameterizing-data-how-do-i-not-use-the-same-data-more-than-once-in-a-test/42/2) or [`SharedArray`](https://k6.io/docs/javascript-api/k6-data/sharedarray/), can be done by using the `scenario.iterationInTest` property, which is guaranteed to be unique across VUs, even for distributed or cloud tests. For example:

```js
import exec from "k6/execution";
import { SharedArray } from "k6/data";

const data = new SharedArray("my dataset", function(){
  return JSON.parse(open('my-large-dataset.json'));
})

export const options = {
  scenarios :{
    "use-all-the-data": {
      executor: "shared-iterations",
      vus: 100,
      iterations: data.length,
      maxDuration: "1h"
    }
  }
}

export default function() {
  // this is unique even in the cloud
  var item = data[exec.scenario.iterationInTest];
  http.post("https://httpbin.test.k6.io/anything?endpoint=amazing", item)
}
```

You can read the full documentation [here](https://k6.io/docs/javascript-api/k6-execution).

## Enhancements and UX improvements

* Warn Windows users on importing dependencies or opening files as absolute paths ([#2078](https://github.com/grafana/k6/pull/2078)).
* Pass setup data object into [handleSummary callback](https://k6.io/docs/results-visualization/end-of-test-summary/#handlesummary-callback) ([#2103](https://github.com/grafana/k6/pull/2103)). Thanks, @SamuelJohnson01997!

## Breaking changes

* The deprecated outputs Datadog and Kafka have been removed ([#2081](https://github.com/grafana/k6/pull/2081)).

## Bugs fixed!

* Use the `POST` HTTP request method instead of `GET` for pushing logs to Loki ([#2100](https://github.com/grafana/k6/pull/2100)).
* Encode the [`blacklistIPs` option](https://k6.io/docs/using-k6/options/#blacklist-ips) using the CIDR notation in JSON ([#2083](https://github.com/grafana/k6/pull/2083)).
* `ext.loadimpact` option has the same precedence as the script configuration during the consolidation process ([#2099](https://github.com/grafana/k6/pull/2099)).
* The WebSocket connection used for tailing logs from the k6 Cloud is reestablished in the case of an unexpected error ([#2090](https://github.com/grafana/k6/pull/2090)).

## Internals

* A simpler and clearer API has been added as an alternative to `common.Bind`, which also gives JS modules and extensions easy access to some [useful internal objects and runtime information](https://pkg.go.dev/go.k6.io/k6@v0.34.0/js/modules#Instance) ([#2108](https://github.com/grafana/k6/pull/2108)). This API is not yet stable, it's very likely to change more in future k6 versions.
* Speeding ups TC39 tests using a pool of Babel compilers ([#1839](https://github.com/grafana/k6/pull/1839)).
* Goja and some internal dependencies have been updated adding the native support for Arrow functions, Destructuring, Default arguments and Computed properties features. For the same reason, the relative Babel's plugins supporting those features are not required anymore so they have been disabled ([#2109](https://github.com/grafana/k6/pull/2109), [#2092](https://github.com/grafana/k6/pull/2092)).
